<?php
/* --------------------------------------------------------------
 GambioAdminBootstrapper.php 2021-11-03
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2021 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

declare(strict_types=1);

namespace Gambio\Admin\Application;

use Gambio\Admin\Application\Bootstrapper\AdminErrorHandlerRegistration;
use Gambio\Admin\Application\Bootstrapper\AdminServiceProviderRegistration;
use Gambio\Admin\Application\Bootstrapper\LoadConfiguration;
use Gambio\Admin\Application\Bootstrapper\MiddlewareRegistration;
use Gambio\Admin\Application\Bootstrapper\ModulesMiddlewareRegistration;
use Gambio\Admin\Application\Bootstrapper\ProductOptionsVpeTransitionBootstrapper;
use Gambio\Admin\Application\Bootstrapper\RouteRegistration;
use Gambio\Admin\Application\Bootstrapper\TokenServiceRegistration;
use Gambio\Core\Application\Application;
use Gambio\Core\Application\Bootstrapper;
use Gambio\Core\Application\Bootstrapper\CoreBootstrapper;

/**
 * Class GambioAdminBootstrapper
 * @package Gambio\Admin\Application
 */
class GambioAdminBootstrapper extends CoreBootstrapper implements Bootstrapper
{
    /**
     * @inheritDoc
     */
    public function boot(Application $application): void
    {
        (new LoadConfiguration())->boot($application);
        $this->setSessionParameter($application);
        $this->startSession($application);
        $this->loadEnvironment($application);
        $this->loadServerInformation($application);
        
        $this->registerEventDispatcher($application);
        
        $this->registerCoreServiceProvider($application);
        $this->initDefaultServerConfiguration($application);
        $this->loadUserPreferencesFromSession($application);
        
        (new AdminServiceProviderRegistration())->boot($application);
        (new TokenServiceRegistration())->boot($application);
        
        $this->registerSlimFramework($application);
        (new AdminErrorHandlerRegistration())->boot($application);
        (new MiddlewareRegistration())->boot($application);
        (new RouteRegistration())->boot($application);
    
        (new ProductOptionsVpeTransitionBootstrapper())->boot($application);
        
        $this->registerModules($application);
        (new ModulesMiddlewareRegistration())->boot($application);
    }
}
